/*
 * Decompiled with CFR 0.152.
 */
package my.emslog;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import my.emslog.emslog;

public class SerialComm
implements Runnable,
SerialPortEventListener {
    private InputStream inputStream;
    private OutputStream outputStream;
    private SerialPort serialPort;
    private Thread readThread = null;
    private byte[] dataBlock = new byte[4096];
    private static int numBytes = 0;
    private boolean connected = false;
    private int DAcnt;
    private static int[] dataBuffer = new int[2048];
    private static int[] sndBuffer = new int[1024];
    private static int bufferOffset = 0;
    private static int bufferLength = 0;
    public static Long timeTmp;

    public SerialComm() {
        int loop;
        for (loop = 0; loop < 2047; ++loop) {
            SerialComm.dataBuffer[loop] = -1;
        }
        for (loop = 0; loop < 1023; ++loop) {
            SerialComm.sndBuffer[loop] = -1;
        }
        this.connected = false;
    }

    public void connect(CommPortIdentifier portId, byte[] destDataBlk) {
        this.DAcnt = 0;
        try {
            this.serialPort = (SerialPort)portId.open("SerialReader", 2000);
        }
        catch (PortInUseException e) {
            emslog.logTxt("\n(" + portId.getName() + "): Port ist schon belegt!\n");
        }
        try {
            this.inputStream = this.serialPort.getInputStream();
            this.outputStream = this.serialPort.getOutputStream();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.serialPort.addEventListener(this);
        }
        catch (TooManyListenersException e) {
            // empty catch block
        }
        this.serialPort.notifyOnDataAvailable(true);
        try {
            this.serialPort.setSerialPortParams(9600, 8, 1, 0);
            this.serialPort.setFlowControlMode(0);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            // empty catch block
        }
        this.readThread = new Thread(this);
        this.readDataframe(destDataBlk);
        this.connected = true;
    }

    public boolean getConnected() {
        return this.connected;
    }

    public void setConnected(boolean bool) {
        this.connected = bool;
    }

    public void disconnect() {
        this.readThread.interrupt();
        this.serialPort.removeEventListener();
        this.serialPort.close();
        this.connected = false;
    }

    public int readDataframe(byte[] destDataBlock) {
        numBytes = 0;
        this.dataBlock = destDataBlock;
        int returnValue = -1;
        if (this.readThread != null) {
            this.readThread.start();
            returnValue = numBytes;
        }
        return returnValue;
    }

    public void run() {
        try {
            while (numBytes < 1024) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 2: {
                break;
            }
            case 1: {
                this.logData();
            }
        }
    }

    public void sendData(ByteArrayOutputStream outBuf) {
        try {
            this.outputStream.write(outBuf.toByteArray());
        }
        catch (IOException ex) {
            Logger.getLogger(SerialComm.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void logData() {
        try {
            while (this.inputStream.available() > 0) {
                SerialComm.dataBuffer[SerialComm.bufferOffset + SerialComm.bufferLength & 0x7FF] = this.inputStream.read() & 0xFF;
                ++bufferLength;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        int check = -1;
        while (check == -1) {
            check = this.extractFrameFromRingBuffer();
        }
    }

    private int extractFrameFromRingBuffer() {
        int retValue = 0;
        int loop = 0;
        for (loop = 0; loop < 200; ++loop) {
            SerialComm.sndBuffer[loop] = -1;
        }
        for (loop = 0; loop < bufferLength - 0; ++loop) {
            SerialComm.sndBuffer[loop] = dataBuffer[bufferOffset + loop & 0x7FF] & 0xFF;
            if (loop < 5 || sndBuffer[loop] != 85 || sndBuffer[loop - 1] != 170) continue;
            SerialComm.sndBuffer[loop + 2] = -1;
            retValue = -1;
            break;
        }
        if (retValue == -1) {
            this.deleteValuesInRingBuffer(loop + 1);
            emslog.showTelegrams(sndBuffer);
        }
        return retValue;
    }

    private void deleteValuesInRingBuffer(int chars) {
        SerialComm.dataBuffer[SerialComm.bufferOffset & 0x7FF] = -1;
        bufferOffset += chars;
        bufferLength -= chars;
    }

    private int cutRingBuffer() {
        --bufferLength;
        int value = dataBuffer[++bufferOffset & 0x7FF];
        SerialComm.dataBuffer[SerialComm.bufferOffset & 0x7FF] = -1;
        return value;
    }

    private int readRingBuffer(int offset) {
        int counter = bufferOffset + offset & 0x7FF;
        int value = dataBuffer[counter];
        return value;
    }

    private void writeRingBuffer(int value) {
        SerialComm.dataBuffer[SerialComm.bufferOffset + SerialComm.bufferLength & 0x7FF] = value & 0xFF;
        ++bufferLength;
    }

    private void extractFrames() {
        int loop = 0;
        timeTmp = System.currentTimeMillis();
        for (loop = 0; loop < 900; ++loop) {
            --bufferLength;
            SerialComm.sndBuffer[loop] = dataBuffer[++bufferOffset & 0x7FF];
            SerialComm.dataBuffer[SerialComm.bufferOffset & 0x7FF] = -1;
        }
        while (loop < 2045) {
            if ((dataBuffer[bufferOffset] & 0xFF) == 170 & (dataBuffer[bufferOffset + 1] & 0xFF) == 85) {
                --bufferLength;
                SerialComm.sndBuffer[loop] = dataBuffer[++bufferOffset & 0x7FF];
                SerialComm.dataBuffer[SerialComm.bufferOffset & 0x7FF] = -1;
                break;
            }
            --bufferLength;
            SerialComm.sndBuffer[loop] = dataBuffer[++bufferOffset & 0x7FF];
            SerialComm.dataBuffer[SerialComm.bufferOffset & 0x7FF] = -1;
            ++loop;
        }
    }

    public static void showTelegrams(int[] data) {
        int loop = 0;
        int[] telegramArray = new int[128];
        while (data[loop] > -1) {
            for (loop = 2; loop < 2047 && data[loop] != -1; ++loop) {
                if (!(data[loop - 2] == 170 & data[loop - 1] == 85)) continue;
                int telStart = loop;
                while (!(data[loop + 1] == 170 & data[loop + 2] == 85)) {
                    ++loop;
                }
                System.arraycopy(data, telStart, telegramArray, 0, loop - telStart);
                telegramArray[loop - telStart] = -1;
                telegramArray[loop - telStart + 1] = -1;
            }
        }
    }

    private void sndData() {
        int loop = 0;
        timeTmp = System.currentTimeMillis();
        for (loop = 0; loop < 900; ++loop) {
            --bufferLength;
            SerialComm.sndBuffer[loop] = dataBuffer[++bufferOffset & 0x7FF];
            SerialComm.dataBuffer[SerialComm.bufferOffset & 0x7FF] = -1;
        }
        while (loop < 2043) {
            if ((dataBuffer[bufferOffset] & 0xFF) == 170 & (dataBuffer[bufferOffset + 1] & 0xFF) == 85) {
                SerialComm.sndBuffer[loop] = dataBuffer[bufferOffset + 1 & 0x7FF];
                SerialComm.dataBuffer[SerialComm.bufferOffset + 1 & 0x7FF] = -1;
                ++bufferOffset;
                --bufferLength;
                break;
            }
            SerialComm.sndBuffer[loop] = dataBuffer[bufferOffset + 1 & 0x7FF];
            SerialComm.dataBuffer[SerialComm.bufferOffset + 1 & 0x7FF] = -1;
            ++bufferOffset;
            --bufferLength;
            ++loop;
        }
        emslog.showTelegrams(sndBuffer);
    }

    private void logTxt(String text) {
        emslog.logTxt(text);
    }

    private void clrTxt() {
        emslog.clrTxt();
    }
}

