/*
 * Decompiled with CFR 0.152.
 */
package my.emsview;

import java.awt.Color;
import java.awt.Graphics;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JPanel;

public class graph2d
extends JPanel {
    private Color[] color = new Color[9];
    private long chartStart;
    private long chartEnd;
    private int[] scale = new int[9];
    private int[] lenght = new int[9];
    private int[][] line = new int[9][16384];
    private int[][] polyLineX;
    private int[][] polyLineY;
    private long[][] time = new long[9][16384];
    private int interval = 3;
    private int start = -2;
    private int startTime = 0;
    private int endTime;
    private int yZoom = 1;
    private int yOffset = 0;
    private int realYOffset = 0;
    private final int bottomBorder = 0;
    private final int leftBorder = 0;

    public graph2d() {
        this.polyLineX = new int[9][16384];
        this.polyLineY = new int[9][16384];
        for (int curve = 1; curve < 9; ++curve) {
            this.scale[curve] = 100;
            this.lenght[curve] = 1;
            for (int loop = 0; loop < 16383; ++loop) {
                this.line[curve][loop] = 0;
                this.polyLineX[curve][loop] = 16384;
                this.polyLineY[curve][loop] = 16384;
            }
        }
        this.color[1] = new Color(255, 0, 0);
        this.color[2] = new Color(0, 200, 0);
        this.color[3] = new Color(0, 0, 255);
        this.color[4] = new Color(0, 0, 0);
        this.color[5] = new Color(255, 0, 255);
        this.color[6] = new Color(255, 255, 0);
        this.color[7] = new Color(0, 255, 255);
        this.color[8] = new Color(255, 255, 255);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth() - 1;
        int height = this.getHeight() - 1;
        this.getClass();
        int chartHeight = height - 0;
        this.getClass();
        int chartWidth = width - 0;
        g.setColor(Color.LIGHT_GRAY);
        for (int loop = 1; loop < 11; ++loop) {
            this.getClass();
            g.drawLine(0, chartHeight - loop * chartHeight / 10 * this.yZoom, width, chartHeight - loop * chartHeight / 10 * this.yZoom);
        }
        int hourDist = chartWidth * 10000 / (24 * this.interval - (this.startTime + (24 - this.endTime)));
        for (int loop2 = 1; loop2 < 24 * this.interval - (this.startTime + (24 - this.endTime)); ++loop2) {
            g.setColor(Color.LIGHT_GRAY);
            if ((loop2 + this.startTime) % 6 == 0) {
                g.setColor(Color.GRAY);
            }
            if ((loop2 + this.startTime) % 24 == 0) {
                g.setColor(Color.BLACK);
            }
            this.getClass();
            int n = 0 + hourDist * loop2 / 10000;
            this.getClass();
            g.drawLine(n, 0, 0 + hourDist * loop2 / 10000, chartHeight);
        }
        g.setColor(Color.GRAY);
        this.getClass();
        g.drawLine(0, chartHeight, width, chartHeight);
        this.getClass();
        this.getClass();
        this.getClass();
        g.drawLine(0, 0, 0, height - 0);
        g.drawLine(0, 0, width, 0);
        g.drawLine(0, 0, 0, height);
        g.drawLine(width, 0, width, height);
        g.drawLine(0, height, width, height);
        g.setColor(new Color(192, 0, 0));
        long tmpWidth = 0L;
        for (int curve = 1; curve < 9; ++curve) {
            int loop;
            for (int tmpLoop = 0; tmpLoop < 16384; ++tmpLoop) {
                if (this.line[curve][tmpLoop] == 32768) continue;
                this.lenght[curve] = tmpLoop;
            }
            if (this.line[curve][0] == 32768) {
                this.lenght[curve] = 1;
            }
            if (this.scale[curve] <= 0) continue;
            for (loop = 0; loop < this.lenght[curve] - 1; ++loop) {
                tmpWidth = (86400000L * (long)this.interval - 3600000L * (long)(this.startTime + (24 - this.endTime))) / (long)chartWidth;
                int[] nArray = this.polyLineX[curve];
                this.getClass();
                nArray[loop] = 0 + (int)((this.time[curve][loop] - (long)this.startTime * 3600000L) / tmpWidth);
                int[] nArray2 = this.polyLineY[curve];
                this.getClass();
                this.getClass();
                int n = height - 0 - (height - 0) / 100 * (this.yOffset * this.yZoom);
                int n2 = this.line[curve][loop];
                this.getClass();
                nArray2[loop] = n - n2 * (height - 0) / 100 / this.scale[curve] * this.yZoom + this.realYOffset;
            }
            g.setColor(this.color[curve]);
            for (loop = 1; loop < this.lenght[curve] - 1; ++loop) {
                if (this.time[curve][loop] - this.time[curve][loop - 1] > 1800000L) continue;
                g.drawLine(this.polyLineX[curve][loop - 1], this.polyLineY[curve][loop - 1], this.polyLineX[curve][loop], this.polyLineY[curve][loop - 1]);
                g.drawLine(this.polyLineX[curve][loop], this.polyLineY[curve][loop - 1], this.polyLineX[curve][loop], this.polyLineY[curve][loop]);
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        g.setColor(Color.GRAY);
        g.drawString("" + dateFormat.format(new Date()), width - 118, 14);
    }

    public void setDataTime(int line, long[] time, int lenght) {
        for (int loop = 0; loop < lenght; ++loop) {
            this.time[line][loop] = time[loop];
            this.lenght[line] = lenght;
        }
        this.repaint();
    }

    public void setDataLine(int line, int[] data, int lenght) {
        for (int loop = 0; loop < lenght; ++loop) {
            this.line[line][loop] = data[loop];
            this.lenght[line] = lenght;
        }
        this.repaint();
    }

    public void setLenght(int line, int lenght) {
        this.lenght[line] = lenght;
    }

    public void setScale(int line, int scale) {
        this.scale[line] = scale;
    }

    public void setChartStart(long time) {
        this.chartStart = time;
    }

    public void setChartEnd(long time) {
        this.chartEnd = time;
    }

    public void setStartTime(int hour) {
        this.startTime = hour;
    }

    public void setEndTime(int hour) {
        this.endTime = hour;
    }

    public long getChartStart() {
        return this.chartStart;
    }

    public long getChartEnd() {
        return this.chartEnd;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setZoom(int zoom) {
        if (zoom >= 1) {
            this.yZoom = zoom;
        }
    }

    public int getZoom() {
        return this.yZoom;
    }

    public void setOffset(int offset) {
        this.yOffset = offset;
    }

    public int getOffset() {
        return this.yOffset;
    }

    public String getXValue(int xKoord) {
        int width = this.getWidth() - 1;
        this.getClass();
        int chartWidth = width - 0;
        float xKoordReturn = xKoord * 864000 / chartWidth;
        return "" + graph2d.formatDecimal((int)(xKoordReturn / (float)(36000 / this.interval) + (float)this.startTime), 2) + ":" + graph2d.formatDecimal(xKoordReturn % (float)(36000 / this.interval) / (float)(600 / this.interval), 2);
    }

    private static String formatDecimal(double value, int length) {
        String tmpString = "" + (int)value;
        for (int loop = 0; loop < length; ++loop) {
            tmpString = "0" + tmpString;
        }
        return tmpString.substring(tmpString.length() - length, tmpString.length());
    }

    public String getYValue(int yKoord) {
        int width = this.getWidth() - 1;
        int height = this.getHeight() - 1;
        this.getClass();
        int chartHeight = height - 0;
        this.getClass();
        int chartWidth = width - 0;
        float yKoordReturn = (chartHeight - yKoord) * 1000 / chartHeight / this.yZoom;
        return "" + (yKoordReturn / 10.0f - (float)this.yOffset);
    }

    public void printValues() {
    }

    public void setZoomWindow(int yKoord, int zoom) {
        if (zoom >= 1) {
            int height = this.getHeight() - 1;
            this.getClass();
            int chartHeight = height - 0;
            int tmpYKoord = (chartHeight - yKoord) * (chartHeight * this.yZoom / 100);
            System.out.println("Value:" + tmpYKoord / 10);
            ++this.yZoom;
            int tmpOffset = tmpYKoord - chartHeight / 100 / (this.yZoom * 2);
            this.realYOffset = tmpOffset * 100 / 855;
        }
        if (zoom <= -1) {
            --this.yZoom;
        }
        if (this.yZoom <= 1) {
            this.yZoom = 1;
            System.err.println("YOffset:" + this.realYOffset);
            this.realYOffset = 0;
        }
        this.repaint();
    }
}

