/*
 * Decompiled with CFR 0.152.
 */
package my.emslog;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.TooManyListenersException;
import my.emslog.emslog;

public class SerialReader
implements Runnable,
SerialPortEventListener {
    private InputStream inputStream;
    private InputStream input;
    private SerialPort serialPort;
    private Thread readThread = null;
    private byte[] dataBlock = new byte[4096];
    private static int numBytes = 0;
    private boolean connected = false;
    private static boolean lineFeed = true;
    private static byte[] buffer = new byte[4096];
    private static int length;
    private int DAcnt;
    private static int[] dataBuffer;
    private static int[] sndBuffer;
    private static int bufferOffset;
    private static int bufferLength;
    private String test1;
    private String test2;
    public static Long timeTmp;

    public SerialReader() {
        int loop;
        for (loop = 0; loop < 2047; ++loop) {
            SerialReader.dataBuffer[loop] = -1;
        }
        for (loop = 0; loop < 1023; ++loop) {
            SerialReader.sndBuffer[loop] = -1;
        }
        this.connected = false;
    }

    public void connect(CommPortIdentifier portId, byte[] destDataBlk) {
        this.DAcnt = 0;
        try {
            this.serialPort = (SerialPort)portId.open("SerialReader", 2000);
        }
        catch (PortInUseException e) {
            emslog.logTxt("\n(" + portId.getName() + "): Port ist schon belegt!\n");
        }
        try {
            this.inputStream = this.serialPort.getInputStream();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.serialPort.addEventListener(this);
        }
        catch (TooManyListenersException e) {
            // empty catch block
        }
        this.serialPort.notifyOnDataAvailable(true);
        try {
            this.serialPort.setSerialPortParams(9600, 8, 1, 0);
            this.serialPort.setFlowControlMode(0);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            // empty catch block
        }
        this.readThread = new Thread(this);
        this.readDataframe(destDataBlk);
        this.connected = true;
    }

    public boolean getConnected() {
        return this.connected;
    }

    public void setConnected(boolean bool) {
        this.connected = bool;
    }

    public void disconnect() {
        this.readThread.interrupt();
        this.serialPort.removeEventListener();
        this.serialPort.close();
        this.connected = false;
    }

    public int readDataframe(byte[] destDataBlock) {
        numBytes = 0;
        this.dataBlock = destDataBlock;
        int returnValue = -1;
        if (this.readThread != null) {
            this.readThread.start();
            returnValue = numBytes;
        }
        return returnValue;
    }

    public void run() {
        try {
            while (numBytes < 1024) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 2: {
                break;
            }
            case 1: {
                this.logData();
                this.connected = false;
            }
        }
        this.connected = false;
    }

    private void logData() {
        try {
            while (this.inputStream.available() > 0) {
                SerialReader.dataBuffer[SerialReader.bufferOffset + SerialReader.bufferLength & 0x7FF] = this.inputStream.read() & 0xFF;
                ++bufferLength;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (bufferLength > 1027) {
            bufferOffset &= 0x7FF;
            this.sndData();
        }
    }

    private void sndData() {
        int loop = 0;
        timeTmp = System.currentTimeMillis();
        for (loop = 0; loop < 11; ++loop) {
            --bufferLength;
            SerialReader.sndBuffer[loop] = dataBuffer[++bufferOffset & 0x7FF];
            SerialReader.dataBuffer[SerialReader.bufferOffset & 0x7FF] = -1;
        }
        while (loop < 1020) {
            this.test1 = Integer.toHexString(dataBuffer[bufferOffset] & 0xFF);
            this.test2 = Integer.toHexString(dataBuffer[bufferOffset + 1] & 0xFF);
            if ((dataBuffer[bufferOffset] & 0xFF) == 170 & (dataBuffer[bufferOffset + 1] & 0xFF) == 85) {
                SerialReader.sndBuffer[loop] = dataBuffer[bufferOffset + 1 & 0x7FF];
                SerialReader.dataBuffer[SerialReader.bufferOffset + 1 & 0x7FF] = -1;
                ++bufferOffset;
                --bufferLength;
                break;
            }
            SerialReader.sndBuffer[loop] = dataBuffer[bufferOffset + 1 & 0x7FF];
            SerialReader.dataBuffer[SerialReader.bufferOffset + 1 & 0x7FF] = -1;
            ++bufferOffset;
            --bufferLength;
            ++loop;
        }
        emslog.rcvData(sndBuffer);
    }

    private void logTxt(String text) {
        emslog.logTxt(text);
    }

    private void clrTxt() {
        emslog.clrTxt();
    }

    static {
        dataBuffer = new int[2048];
        sndBuffer = new int[1024];
        bufferOffset = 0;
        bufferLength = 0;
    }
}

