/*
 * Decompiled with CFR 0.152.
 */
package my.emslog;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TwoWaySerialComm {
    void connect(String portName) throws Exception {
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier(portName);
        if (portIdentifier.isCurrentlyOwned()) {
            System.out.println("Error: Port is currently in use");
        } else {
            CommPort commPort = portIdentifier.open(this.getClass().getName(), 2000);
            if (commPort instanceof SerialPort) {
                SerialPort serialPort = (SerialPort)commPort;
                serialPort.setSerialPortParams(9600, 8, 1, 0);
                InputStream in = serialPort.getInputStream();
                OutputStream out = serialPort.getOutputStream();
                serialPort.addEventListener(new SerialReader(in));
                serialPort.notifyOnDataAvailable(true);
            } else {
                System.out.println("Error: Only serial ports are handled by this example.");
            }
        }
    }

    public static void main(String[] args) {
        try {
            new TwoWaySerialComm().connect("COM1");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class SerialReader
    implements SerialPortEventListener {
        private InputStream in;
        private byte[] buffer = new byte[1024];

        public SerialReader(InputStream in) {
            this.in = in;
        }

        public void serialEvent(SerialPortEvent arg0) {
            try {
                int data;
                int len = 0;
                while ((data = this.in.read()) > -1 && data != 10) {
                    this.buffer[len++] = (byte)data;
                }
                System.out.print(new String(this.buffer, 0, len));
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }
}

