/*
 * Decompiled with CFR 0.152.
 */
package my.emslog;

import gnu.io.CommPortIdentifier;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import my.emslog.SerialReader;
import my.emslog.decode;
import my.emslog.log;
import my.emslog.mysqllog;

public class emslog
extends JFrame {
    byte[] dataFrame;
    private static int[] index = new int[9];
    public static final int lineLenght = 1000;
    private static int[][] line = new int[9][1000];
    private static long[][] time = new long[9][1000];
    private static long tmpTime;
    private static long tmpTime2;
    SerialReader serialReader = new SerialReader();
    private static int[] rcvBuffer;
    public static final int ARRAYSIZE = 50;
    public static Timestamp[] tmpTimestamp;
    public static int[] tmpValue;
    public static boolean[] tmpSaveBool;
    JButton BtnConnect;
    JButton BtnDisconnect;
    JComboBox CbCom;
    static JCheckBox cbLogCRCFail;
    static JCheckBox cbLogFrames;
    static JCheckBox cbLogPolling;
    JLabel jLabel1;
    JLabel jLabel10;
    JLabel jLabel11;
    JLabel jLabel12;
    JLabel jLabel13;
    JLabel jLabel14;
    JLabel jLabel15;
    JLabel jLabel16;
    JLabel jLabel17;
    JLabel jLabel18;
    JLabel jLabel19;
    JLabel jLabel2;
    JLabel jLabel20;
    JLabel jLabel3;
    JLabel jLabel4;
    JLabel jLabel5;
    JLabel jLabel6;
    JLabel jLabel7;
    JLabel jLabel8;
    JLabel jLabel9;
    JScrollPane jScrollPane1;
    static JTextArea jTextArea1;
    private static JTextField tfAnlageIst;
    private static JTextField tfAussenIst;
    private static JTextField tfBetriebsStunden;
    private static JTextField tfBrennerStarts;
    static JTextField tfCRCError;
    private static JTextField tfDatum;
    private static JTextField tfKesselIst;
    private static JTextField tfLeistungIst;
    static JTextField tfLineCount;
    private static JTextField tfMaxLeistung;
    static JTextField tfMySQLIP;
    static JPasswordField tfMySQLPassword;
    static JTextField tfMySQLUser;
    private static JTextField tfRaumIst;
    private static JTextField tfRaumSoll;
    private static JTextField tfWasserIst;
    private static JTextField tfWasserSoll;
    private static JTextField tfZeit;
    private static String ipAddress;

    public emslog() {
        this.initComponents();
        this.setBounds(17, 50, 990, 400);
        this.initOwnComponents();
        this.dataFrame = new byte[4096];
        tmpTime = 0L;
    }

    private void initComponents() {
        this.CbCom = new JComboBox();
        this.BtnConnect = new JButton();
        this.BtnDisconnect = new JButton();
        this.jLabel1 = new JLabel();
        tfAussenIst = new JTextField();
        this.jLabel2 = new JLabel();
        tfRaumSoll = new JTextField();
        this.jLabel3 = new JLabel();
        tfRaumIst = new JTextField();
        this.jLabel4 = new JLabel();
        tfWasserIst = new JTextField();
        this.jLabel5 = new JLabel();
        tfWasserSoll = new JTextField();
        this.jLabel6 = new JLabel();
        tfAnlageIst = new JTextField();
        this.jLabel7 = new JLabel();
        tfKesselIst = new JTextField();
        this.jLabel8 = new JLabel();
        tfBetriebsStunden = new JTextField();
        this.jLabel9 = new JLabel();
        tfBrennerStarts = new JTextField();
        this.jLabel10 = new JLabel();
        tfMaxLeistung = new JTextField();
        this.jLabel11 = new JLabel();
        tfLeistungIst = new JTextField();
        this.jLabel12 = new JLabel();
        tfDatum = new JTextField();
        this.jLabel13 = new JLabel();
        tfZeit = new JTextField();
        tfMySQLIP = new JTextField();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        tfMySQLUser = new JTextField();
        tfMySQLPassword = new JPasswordField();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        jTextArea1 = new JTextArea();
        this.jLabel18 = new JLabel();
        tfCRCError = new JTextField();
        tfLineCount = new JTextField();
        this.jLabel19 = new JLabel();
        cbLogFrames = new JCheckBox();
        this.jLabel20 = new JLabel();
        cbLogPolling = new JCheckBox();
        cbLogCRCFail = new JCheckBox();
        this.setDefaultCloseOperation(3);
        this.setTitle("EMS Logger V 0.1");
        this.setBounds(new Rectangle(17, 200, 990, 400));
        this.setMinimumSize(new Dimension(495, 180));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                emslog.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                emslog.this.formComponentResized(evt);
            }
        });
        this.getContentPane().setLayout(null);
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        ArrayList<String> itemList = new ArrayList<String>();
        while (portList.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1) continue;
            itemList.add(portId.getName());
        }
        this.CbCom.setModel(new DefaultComboBoxModel<Object>(itemList.toArray()));
        this.CbCom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                emslog.this.CbComActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.CbCom);
        this.CbCom.setBounds(670, 80, 80, 20);
        this.BtnConnect.setText("Verbinden");
        this.BtnConnect.setActionCommand("BtnConnect");
        this.BtnConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                emslog.this.BtnConnectActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.BtnConnect);
        this.BtnConnect.setBounds(760, 80, 100, 20);
        this.BtnConnect.getAccessibleContext().setAccessibleName("BtnConnect");
        this.BtnDisconnect.setText("Trennen");
        this.BtnDisconnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                emslog.this.BtnDisconnectActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.BtnDisconnect);
        this.BtnDisconnect.setBounds(870, 80, 100, 20);
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setText("Au\u00dfen");
        this.jLabel1.setHorizontalTextPosition(2);
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(530, 60, 60, 14);
        this.getContentPane().add(tfAussenIst);
        tfAussenIst.setBounds(530, 80, 60, 20);
        this.jLabel2.setHorizontalAlignment(2);
        this.jLabel2.setText("Raum SOLL");
        this.jLabel2.setHorizontalTextPosition(2);
        this.getContentPane().add(this.jLabel2);
        this.jLabel2.setBounds(10, 10, 70, 14);
        this.getContentPane().add(tfRaumSoll);
        tfRaumSoll.setBounds(10, 30, 70, 20);
        this.jLabel3.setHorizontalAlignment(2);
        this.jLabel3.setText("Raum IST");
        this.jLabel3.setHorizontalTextPosition(2);
        this.getContentPane().add(this.jLabel3);
        this.jLabel3.setBounds(10, 60, 70, 14);
        this.getContentPane().add(tfRaumIst);
        tfRaumIst.setBounds(10, 80, 70, 20);
        this.jLabel4.setHorizontalAlignment(2);
        this.jLabel4.setText("Wasser SOLL");
        this.jLabel4.setHorizontalTextPosition(2);
        this.getContentPane().add(this.jLabel4);
        this.jLabel4.setBounds(90, 10, 70, 14);
        this.getContentPane().add(tfWasserIst);
        tfWasserIst.setBounds(90, 80, 70, 20);
        this.jLabel5.setHorizontalAlignment(2);
        this.jLabel5.setText("Wasser IST");
        this.jLabel5.setHorizontalTextPosition(2);
        this.getContentPane().add(this.jLabel5);
        this.jLabel5.setBounds(90, 60, 70, 14);
        this.getContentPane().add(tfWasserSoll);
        tfWasserSoll.setBounds(90, 30, 70, 20);
        this.jLabel6.setHorizontalAlignment(2);
        this.jLabel6.setText("Anlage");
        this.jLabel6.setHorizontalTextPosition(2);
        this.getContentPane().add(this.jLabel6);
        this.jLabel6.setBounds(170, 60, 70, 14);
        this.getContentPane().add(tfAnlageIst);
        tfAnlageIst.setBounds(170, 80, 70, 20);
        this.jLabel7.setHorizontalAlignment(2);
        this.jLabel7.setText("Kessel");
        this.jLabel7.setHorizontalTextPosition(2);
        this.getContentPane().add(this.jLabel7);
        this.jLabel7.setBounds(170, 10, 70, 14);
        this.getContentPane().add(tfKesselIst);
        tfKesselIst.setBounds(170, 30, 70, 20);
        this.jLabel8.setHorizontalAlignment(2);
        this.jLabel8.setText("Betriebstunden");
        this.jLabel8.setHorizontalTextPosition(2);
        this.getContentPane().add(this.jLabel8);
        this.jLabel8.setBounds(440, 10, 80, 14);
        this.getContentPane().add(tfBetriebsStunden);
        tfBetriebsStunden.setBounds(440, 30, 80, 20);
        this.jLabel9.setHorizontalAlignment(2);
        this.jLabel9.setText("Brennerstarts");
        this.jLabel9.setHorizontalTextPosition(2);
        this.getContentPane().add(this.jLabel9);
        this.jLabel9.setBounds(440, 60, 80, 14);
        this.getContentPane().add(tfBrennerStarts);
        tfBrennerStarts.setBounds(440, 80, 80, 20);
        this.jLabel10.setHorizontalAlignment(2);
        this.jLabel10.setText("max. Leistung");
        this.jLabel10.setHorizontalTextPosition(2);
        this.getContentPane().add(this.jLabel10);
        this.jLabel10.setBounds(250, 10, 67, 14);
        this.getContentPane().add(tfMaxLeistung);
        tfMaxLeistung.setBounds(250, 30, 70, 20);
        this.jLabel11.setHorizontalAlignment(2);
        this.jLabel11.setText("akt. Leistung");
        this.jLabel11.setHorizontalTextPosition(2);
        this.getContentPane().add(this.jLabel11);
        this.jLabel11.setBounds(250, 60, 70, 14);
        this.getContentPane().add(tfLeistungIst);
        tfLeistungIst.setBounds(250, 80, 70, 20);
        this.jLabel12.setHorizontalAlignment(2);
        this.jLabel12.setText("Datum");
        this.jLabel12.setHorizontalTextPosition(2);
        this.getContentPane().add(this.jLabel12);
        this.jLabel12.setBounds(330, 10, 100, 14);
        this.getContentPane().add(tfDatum);
        tfDatum.setBounds(330, 30, 100, 20);
        this.jLabel13.setHorizontalAlignment(2);
        this.jLabel13.setText("Zeit");
        this.jLabel13.setHorizontalTextPosition(2);
        this.getContentPane().add(this.jLabel13);
        this.jLabel13.setBounds(330, 60, 100, 14);
        this.getContentPane().add(tfZeit);
        tfZeit.setBounds(330, 80, 100, 20);
        tfMySQLIP.setText(ipAddress);
        tfMySQLIP.setName("ipMySQL");
        tfMySQLIP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                emslog.this.tfMySQLIPActionPerformed(evt);
            }
        });
        this.getContentPane().add(tfMySQLIP);
        tfMySQLIP.setBounds(670, 30, 80, 20);
        tfMySQLIP.getAccessibleContext().setAccessibleName("ipMySQL");
        this.jLabel14.setText("Seriell / Heizung");
        this.getContentPane().add(this.jLabel14);
        this.jLabel14.setBounds(670, 60, 90, 14);
        this.jLabel15.setText("IP / MySQL");
        this.getContentPane().add(this.jLabel15);
        this.jLabel15.setBounds(670, 10, 90, 14);
        tfMySQLUser.setText("root");
        this.getContentPane().add(tfMySQLUser);
        tfMySQLUser.setBounds(760, 30, 100, 20);
        tfMySQLPassword.setText("password");
        this.getContentPane().add(tfMySQLPassword);
        tfMySQLPassword.setBounds(870, 30, 100, 20);
        this.jLabel16.setText("User");
        this.getContentPane().add(this.jLabel16);
        this.jLabel16.setBounds(760, 10, 100, 14);
        this.jLabel17.setText("Passwort");
        this.getContentPane().add(this.jLabel17);
        this.jLabel17.setBounds(870, 10, 100, 14);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setFocusable(false);
        this.jScrollPane1.setPreferredSize(new Dimension(220, 960));
        jTextArea1.setFont(new Font("Courier New", 0, 12));
        jTextArea1.setAutoscrolls(false);
        this.jScrollPane1.setViewportView(jTextArea1);
        this.getContentPane().add(this.jScrollPane1);
        this.jScrollPane1.setBounds(10, 110, 960, 220);
        this.jLabel18.setHorizontalAlignment(0);
        this.jLabel18.setText("CRC Errors");
        this.getContentPane().add(this.jLabel18);
        this.jLabel18.setBounds(530, 10, 60, 14);
        tfCRCError.setHorizontalAlignment(0);
        tfCRCError.setText("0");
        tfCRCError.setName("tfCRCError");
        tfCRCError.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                emslog.this.tfCRCErrorActionPerformed(evt);
            }
        });
        this.getContentPane().add(tfCRCError);
        tfCRCError.setBounds(530, 30, 60, 20);
        tfLineCount.setHorizontalAlignment(0);
        tfLineCount.setText("10");
        tfLineCount.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                emslog.this.tfLineCountActionPerformed(evt);
            }
        });
        this.getContentPane().add(tfLineCount);
        tfLineCount.setBounds(600, 30, 60, 20);
        this.jLabel19.setHorizontalAlignment(0);
        this.jLabel19.setText("Lines");
        this.getContentPane().add(this.jLabel19);
        this.jLabel19.setBounds(600, 10, 50, 14);
        cbLogFrames.setToolTipText("Telegramme");
        cbLogFrames.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                emslog.this.cbLogFramesActionPerformed(evt);
            }
        });
        this.getContentPane().add(cbLogFrames);
        cbLogFrames.setBounds(600, 80, 20, 21);
        this.jLabel20.setHorizontalAlignment(0);
        this.jLabel20.setText("Fr Poll CRC");
        this.getContentPane().add(this.jLabel20);
        this.jLabel20.setBounds(600, 60, 60, 14);
        cbLogPolling.setToolTipText("Polling");
        cbLogPolling.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                emslog.this.cbLogPollingActionPerformed(evt);
            }
        });
        this.getContentPane().add(cbLogPolling);
        cbLogPolling.setBounds(620, 80, 20, 21);
        cbLogCRCFail.setSelected(true);
        cbLogCRCFail.setToolTipText("CRC-Fehler");
        cbLogCRCFail.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                emslog.this.cbLogCRCFailActionPerformed(evt);
            }
        });
        this.getContentPane().add(cbLogCRCFail);
        cbLogCRCFail.setBounds(640, 80, 20, 21);
        this.pack();
    }

    private void formComponentResized(ComponentEvent evt) {
        this.jScrollPane1.setBounds(10, 110, this.getWidth() - 30, this.getHeight() - 155);
    }

    private void BtnDisconnectActionPerformed(ActionEvent evt) {
        if (this.serialReader != null) {
            if (this.serialReader.getConnected()) {
                emslog.logTxt("(" + this.CbCom.getSelectedItem() + "): Verbindung getrennt!...");
                this.serialReader.setConnected(false);
                this.serialReader.disconnect();
            }
        } else {
            emslog.logTxt("Kein Port ge\u00f6ffnet!");
        }
        mysqllog.closeLogConnection();
        log.closeLogfile();
        System.out.println(".");
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.serialReader != null) {
            if (this.serialReader.getConnected()) {
                emslog.logTxt("Fenster wird geschlossen...");
                this.serialReader.disconnect();
                this.serialReader.setConnected(false);
            }
        } else {
            emslog.logTxt("Kein Port ge\u00f6ffnet!");
        }
        mysqllog.closeConnection();
        log.closeLogfile();
        System.exit(0);
    }

    private void BtnConnectActionPerformed(ActionEvent evt) {
        if (this.serialReader != null) {
            if (!this.serialReader.getConnected()) {
                emslog.clrTxt();
                emslog.logTxt("(" + this.CbCom.getSelectedItem() + "): Die Verbindung wird aufgebaut...");
                String SerialPort2 = (String)this.CbCom.getSelectedItem();
                SerialReader.timeTmp = System.currentTimeMillis();
                try {
                    this.loadData(SerialPort2);
                }
                catch (Exception e) {
                    System.err.println(e);
                }
                System.out.println();
                this.serialReader.setConnected(true);
                log.createLogfile();
            } else {
                emslog.logTxt("Port ist bereits ge\u00f6ffnet!");
            }
        }
        mysqllog.openLogConnection(tfMySQLIP.getText(), "emslog", tfMySQLUser.getText(), tfMySQLPassword.getText());
        System.out.println(".");
    }

    private void tfMySQLIPActionPerformed(ActionEvent evt) {
    }

    private void tfCRCErrorActionPerformed(ActionEvent evt) {
    }

    private void CbComActionPerformed(ActionEvent evt) {
    }

    private void tfLineCountActionPerformed(ActionEvent evt) {
    }

    private void cbLogFramesActionPerformed(ActionEvent evt) {
    }

    private void cbLogPollingActionPerformed(ActionEvent evt) {
    }

    private void cbLogCRCFailActionPerformed(ActionEvent evt) {
    }

    private void initOwnComponents() {
    }

    public static void rcvData(int[] data) {
        emslog.showTelegrams(data);
    }

    private static void showTelegrams(int[] data) {
        int loop = 0;
        int[] telegramArray = new int[4096];
        String tmpString = "";
        while (data[loop] > -1) {
            for (loop = 2; loop < 1023 && data[loop] != -1; ++loop) {
                if (!(data[loop - 2] == 170 & data[loop - 1] == 85)) continue;
                int telStart = loop;
                while (!(data[loop + 1] == 170 & data[loop + 2] == 85)) {
                    ++loop;
                }
                System.arraycopy(data, telStart, telegramArray, 0, loop - telStart);
                telegramArray[loop - telStart] = -1;
                telegramArray[loop - telStart + 1] = -1;
                tmpString = decode.showTelegram(telegramArray);
                if (tmpString.length() <= 4) continue;
                emslog.logTxt(tmpString + "\n");
            }
        }
    }

    public static void incCRCError() {
        tfCRCError.setText("" + (Integer.parseInt(tfCRCError.getText()) + 1));
    }

    public static void setAussen(String text) {
        tfAussenIst.setText(text);
    }

    public static void setAnlage(String text) {
        tfAnlageIst.setText(text);
    }

    public static void setRaumIst(String text) {
        tfRaumIst.setText(text);
    }

    public static void setRaumSoll(String text) {
        tfRaumSoll.setText(text);
    }

    public static void setWasserIst(String text) {
        tfWasserIst.setText(text);
    }

    public static void setWasserSoll(String text) {
        tfWasserSoll.setText(text);
    }

    public static void setKesselIst(String text) {
        tfKesselIst.setText(text);
    }

    public static void setBetriebsStunden(String text) {
        tfBetriebsStunden.setText(text);
    }

    public static void setBrennerstarts(String text) {
        tfBrennerStarts.setText(text);
    }

    public static void setDatum(String text) {
        tfDatum.setText(text);
    }

    public static void setZeit(String text) {
        tfZeit.setText(text);
    }

    public static void setMaxLeistung(String text) {
        tfMaxLeistung.setText(text);
    }

    public static void setLeistungIst(String text) {
        tfLeistungIst.setText(text);
    }

    private static void displayArrayAsHexBlock(byte[] byteArray) {
    }

    public static void displayIntArrayAsHexBlock(int[] intArray) {
    }

    private static void toHex(byte value) {
        System.out.println(Integer.toHexString(value & 0xFF));
    }

    public static void main(String[] args) {
        if (args[0] != null) {
            ipAddress = args[0];
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new emslog().setVisible(true);
            }
        });
    }

    public static void logTxt(String text) {
        Integer lineStartOffset;
        Integer cutLines = jTextArea1.getLineCount() - Integer.parseInt(tfLineCount.getText());
        if (cutLines < 0) {
            cutLines = 0;
        }
        try {
            lineStartOffset = jTextArea1.getLineStartOffset(cutLines);
        }
        catch (BadLocationException ex) {
            System.err.println("jTextArea:" + ex);
            lineStartOffset = 0;
        }
        Integer length = jTextArea1.getText().length();
        jTextArea1.setText(jTextArea1.getText().substring(lineStartOffset, length).concat(text));
    }

    public static void clrTxt() {
        jTextArea1.setText("");
    }

    public void loadData(String fileId) throws Exception {
        if (fileId.indexOf("COM") >= 0 | fileId.indexOf("ttyS") >= 0) {
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
                if (portId.getPortType() == 1) {
                    if (!portId.getName().equals(fileId)) continue;
                    tmpTime = System.currentTimeMillis();
                    this.serialReader.connect(portId, this.dataFrame);
                    emslog.logTxt("(" + this.CbCom.getSelectedItem() + "): Verbindung ge\u00f6ffnet! (" + (System.currentTimeMillis() - tmpTime) + "ms)");
                    break;
                }
                System.err.println("Es werden nur RS232-Ports unterst\u00fctzt");
            }
        }
    }

    static {
        rcvBuffer = new int[1024];
        tmpTimestamp = new Timestamp[50];
        tmpValue = new int[50];
        tmpSaveBool = new boolean[50];
        ipAddress = "localhost";
    }
}

