/*
 * Decompiled with CFR 0.152.
 */
package ems2collector;

import ems2collector.convert;
import ems2collector.ems2collector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class emsThread
implements Runnable {
    byte[] inBytes = null;
    Socket emsSocket = null;
    OutputStream out = null;
    InputStream in = null;

    @Override
    public void run() {
        this.inBytes = new byte[255];
        try {
            this.emsSocket = new Socket(ems2collector.getEmsIp(), ems2collector.getEmsPort());
            if (this.emsSocket.isConnected()) {
                System.out.println("Verbindung hergestellt, lokaler Port:" + this.emsSocket.getLocalPort());
                ems2collector.setLokalPortText("" + this.emsSocket.getLocalPort());
            } else {
                System.out.println("Verbindung konnte nicht hergestelltwerden, lokaler Port:" + this.emsSocket.getLocalPort());
                System.out.println("emsSocket.isClosed()=" + this.emsSocket.isClosed());
                ems2collector.setLokalPortText("");
            }
            this.out = this.emsSocket.getOutputStream();
            this.in = this.emsSocket.getInputStream();
            while (!Thread.currentThread().isInterrupted()) {
                int tmpLoop;
                if (ems2collector.getEmsMessageTyped()) {
                    this.handleEmsMessage();
                }
                if (this.in.available() <= 0) continue;
                int laenge = this.in.read(this.inBytes);
                if (ems2collector.getOverheadEnabled().booleanValue()) {
                    tmpLoop = 0;
                } else {
                    tmpLoop = 3;
                    --laenge;
                }
                for (int loop = tmpLoop; loop < laenge && !Thread.currentThread().isInterrupted(); ++loop) {
                    ems2collector.addCollectorText(convert.byte2HexStr(this.inBytes[loop]) + " ");
                }
                ems2collector.addCollectorText("\n");
                ems2collector.addEmsText("\n");
            }
            this.out.close();
            this.in.close();
            this.emsSocket.close();
            if (this.emsSocket.isClosed()) {
                System.out.println("Verbindung wurde getrennt");
                ems2collector.setLokalPortText("");
            } else {
                System.out.println("Fehler beim Verbindungsabbau: emsSocket.isClosed()=" + this.emsSocket.isClosed());
                ems2collector.setLokalPortText("" + this.emsSocket.getLocalPort());
            }
            this.emsSocket = null;
            this.out = null;
            this.in = null;
        }
        catch (IOException ex) {
            Logger.getLogger(ems2collector.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void handleEmsMessage() {
        try {
            byte[] byteBuffer = ems2collector.getTypedEmsMessage();
            this.out.write(byteBuffer);
            this.out.flush();
            ems2collector.addCollectorText("...\n");
            ems2collector.addEmsText((byte)11, byteBuffer);
            ems2collector.addEmsText("\n");
        }
        catch (IOException ex) {
            Logger.getLogger(emsThread.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

